	LIST	P=16C62A
	INCLUDE <P16C62A.INC>
TEMP	EQU	20H
D_OUT	EQU	21H
;
YES	EQU	0FFH
NO	EQU	0H
;
	;
	ORG	0H
	GOTO	START
	;
	ORG	4H
	BSF	STATUS,RP0
	BTFSC	SSPSTAT,R
	GOTO	WAS_READ
WAS_WRITE:
	BCF	STATUS,RP0
	MOVFW	SSPBUF		;CLEAR BF
	XORLW	B'11111111'
	MOVWF	TEMP
	;
	BCF	PIR1,SSPIF	;CLEAR SSPIF
	;
	MOVLW	NO
	MOVWF	D_OUT
	GOTO	END_INT
WAS_READ:
	BCF	STATUS,RP0
	MOVLW	YES
	XORWF	D_OUT,W
	SKPNZ
	GOTO	CLRIF
	;
	MOVFW	TEMP
	MOVWF	SSPBUF		;SET BF
	BSF	SSPCON,CKP	;RELEASE CLOCK LINE
	MOVLW	YES
	MOVWF	D_OUT
CLRIF:
	BCF	PIR1,SSPIF	;CLEAR SSPIF
END_INT:
	RETFIE
	;
START:
	BSF	STATUS,RP0
	MOVLW	B'11111111'
	MOVWF	TRISA
	MOVWF	TRISB
	MOVWF	TRISC
	;
	BCF	STATUS,RP0
	MOVLW	B'00111110'	;I2C SLAVE, 7-BIT WITH INTERRUPT
	MOVWF	SSPCON
	;
	MOVLW	B'00000000'
	MOVWF	PIR1
	;
	BSF	STATUS,RP0
	MOVLW	B'00001110'	;I2C ADDRESS SETTING
	MOVWF	SSPADD
	;
	MOVLW	B'11000000'
	MOVWF	INTCON
	;
	MOVLW	B'00001000'
	MOVWF	PIE1
	;
	BCF	STATUS,RP0	
	MOVLW	NO
	MOVWF	D_OUT
LOOP:
	GOTO	LOOP
	END
